using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace SPStudio
{
	/// <summary>
	/// Form to prompt the user
	/// for data needed to
	/// create a new instance of
	/// ImageContainer.
	/// </summary>
	public class ImageAssociator : System.Windows.Forms.Form
	{
		#region Public Vars
		public String imageFile;
		public bool canceled = false;
		public double degree;
		#endregion

		#region Private Vars
		private bool degreeSet = false;		
		private bool imageSet = false;
		#endregion

		#region Windows Generated Vars
		private System.Windows.Forms.Button SetImageButton;
		private System.Windows.Forms.TextBox ImageLocationTextBox;
		private System.Windows.Forms.Button DoneButton;
		private System.Windows.Forms.Button SetDegreeButton;
		private System.Windows.Forms.Button Cancel_Button;
		private System.Windows.Forms.TextBox DegreeTextBox;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		#region Constructors
		/// <summary>
		/// Standard Constructor that 
		/// initializes components.
		/// Used for creating new instances
		/// of ImageContainer.
		/// </summary>
		public ImageAssociator()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Constructor used to re-assign
		/// data associated with an
		/// already existing ImageContainer.
		/// </summary>
		/// <param name="ImageFile"></param>
		/// <param name="Degree"></param>
		public ImageAssociator(String ImageFile, double Degree)
		{
			InitializeComponent();

			imageSet = true;
			degreeSet = true;
			imageFile = ImageFile;
			degree = Degree;
			DegreeTextBox.Text = degree.ToString();
			ImageLocationTextBox.Text = imageFile;
		}
		#endregion

		#region Dispose Operation
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.SetImageButton = new System.Windows.Forms.Button();
			this.ImageLocationTextBox = new System.Windows.Forms.TextBox();
			this.SetDegreeButton = new System.Windows.Forms.Button();
			this.DegreeTextBox = new System.Windows.Forms.TextBox();
			this.DoneButton = new System.Windows.Forms.Button();
			this.Cancel_Button = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// SetImageButton
			// 
			this.SetImageButton.Location = new System.Drawing.Point(0, 0);
			this.SetImageButton.Name = "SetImageButton";
			this.SetImageButton.Size = new System.Drawing.Size(88, 24);
			this.SetImageButton.TabIndex = 0;
			this.SetImageButton.Text = "Set Image";
			this.SetImageButton.Click += new System.EventHandler(this.SetImageButton_Click);
			// 
			// ImageLocationTextBox
			// 
			this.ImageLocationTextBox.Enabled = false;
			this.ImageLocationTextBox.Font = new System.Drawing.Font("Arial", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.ImageLocationTextBox.Location = new System.Drawing.Point(88, 0);
			this.ImageLocationTextBox.Name = "ImageLocationTextBox";
			this.ImageLocationTextBox.Size = new System.Drawing.Size(200, 22);
			this.ImageLocationTextBox.TabIndex = 1;
			this.ImageLocationTextBox.Text = "NONE";
			// 
			// SetDegreeButton
			// 
			this.SetDegreeButton.Location = new System.Drawing.Point(0, 24);
			this.SetDegreeButton.Name = "SetDegreeButton";
			this.SetDegreeButton.Size = new System.Drawing.Size(88, 23);
			this.SetDegreeButton.TabIndex = 2;
			this.SetDegreeButton.Text = "Set Degree";
			this.SetDegreeButton.Click += new System.EventHandler(this.SetDegreeButton_Click);
			// 
			// DegreeTextBox
			// 
			this.DegreeTextBox.Font = new System.Drawing.Font("Arial", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.DegreeTextBox.Location = new System.Drawing.Point(88, 24);
			this.DegreeTextBox.Name = "DegreeTextBox";
			this.DegreeTextBox.Size = new System.Drawing.Size(200, 22);
			this.DegreeTextBox.TabIndex = 3;
			this.DegreeTextBox.Text = "NONE";
			// 
			// DoneButton
			// 
			this.DoneButton.Location = new System.Drawing.Point(0, 48);
			this.DoneButton.Name = "DoneButton";
			this.DoneButton.Size = new System.Drawing.Size(288, 23);
			this.DoneButton.TabIndex = 4;
			this.DoneButton.Text = "DONE";
			this.DoneButton.Click += new System.EventHandler(this.DoneButton_Click);
			// 
			// Cancel_Button
			// 
			this.Cancel_Button.Location = new System.Drawing.Point(0, 72);
			this.Cancel_Button.Name = "Cancel_Button";
			this.Cancel_Button.Size = new System.Drawing.Size(288, 24);
			this.Cancel_Button.TabIndex = 5;
			this.Cancel_Button.Text = "CANCEL";
			this.Cancel_Button.Click += new System.EventHandler(this.Cancel_Button_Click);
			// 
			// ImageAssociator
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(288, 94);
			this.ControlBox = false;
			this.Controls.Add(this.Cancel_Button);
			this.Controls.Add(this.DoneButton);
			this.Controls.Add(this.DegreeTextBox);
			this.Controls.Add(this.ImageLocationTextBox);
			this.Controls.Add(this.SetDegreeButton);
			this.Controls.Add(this.SetImageButton);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "ImageAssociator";
			this.Text = "Image Associator";
			this.ResumeLayout(false);

		}
		#endregion

		#region Set Image Handler
		/// <summary>
		/// Call setImage() and if
		/// successful then imageSet
		/// will be set to true, otherwise
		/// false.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void SetImageButton_Click(object sender, System.EventArgs e)
		{
			imageSet = setImage();
		}

		/// <summary>
		/// Using an OpenFileDialog assign
		/// an image file location to the String imageFile,
		/// </summary>
		/// <returns></returns>
		private bool setImage()
		{
			OpenFileDialog openFileDialog = new OpenFileDialog();
			openFileDialog.InitialDirectory = "Workspaces";
			openFileDialog.Filter = "jpg files (*.jpg)|*.jpg|bmp files (*.bmp)|*.bmp|gif files (*.gif)|*.gif";
			openFileDialog.FilterIndex = 1 ;
			openFileDialog.RestoreDirectory = true ;

			if(openFileDialog.ShowDialog() == DialogResult.OK)
			{
				imageFile = openFileDialog.FileName;
				openFileDialog.Dispose();
				ImageLocationTextBox.Text = imageFile;				
				return true;
			}		
			else
			{
				openFileDialog.Dispose();
				ImageLocationTextBox.Text = "NONE";
				return false;
			}
		}
		#endregion

		#region Verify and Set Degree Input Method
		/// <summary>
		/// Call setDouble() and if
		/// successful then degreeSet
		/// will be set to true, otherwise
		/// false.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void SetDegreeButton_Click(object sender, System.EventArgs e)
		{
			degreeSet = setDouble();
		}

		/// <summary>
		/// Verify that the String contained in
		/// DegreeTextBox is a usable degree.
		/// </summary>
		/// <returns></returns>
		private bool setDouble()
		{
			String inputDegree = DegreeTextBox.Text.Trim();
			try
			{
				degree = Convert.ToDouble(inputDegree);
				//Translate degree to make sure it
				//is within 0.0 and 360.0
				while(degree>360.0)
					degree-=360.0;
				while(degree<0.0)
					degree+=360.0;
				return true;
			}
			catch (System.OverflowException) 
			{
				MessageBox.Show(
					"Number is too large.");
				return false;
			}
			catch (System.FormatException) 
			{
				MessageBox.Show(
					"The string was not formatted as a decimal value.");
				return false;
			}
			catch (System.ArgumentException) 
			{
				MessageBox.Show(
					"Please enter a number.");
				return false;
			}
		}
		#endregion

		#region Done and Cancel Handlers
		/// <summary>
		/// Verify that data has been
		/// entered correctly.
		/// If so then return
		/// control to the desktop.
		/// The form becomes hidden
		/// and must be disposed of elsewhere.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DoneButton_Click(object sender, System.EventArgs e)
		{
			degreeSet = setDouble();
			if(degreeSet && imageSet)
			{
				Hide();
			}
			else if(degreeSet && !imageSet) MessageBox.Show("Please set an image.");
			else if(!degreeSet && imageSet) MessageBox.Show("Please set a degree.");
			else MessageBox.Show("Please assign a degree and image.");
		}

		/// <summary>
		/// Set the canceled flag and hide
		/// the form, returning control to the
		/// desktop. The form must be 
		/// disposed of elsewhere.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Cancel_Button_Click(object sender, System.EventArgs e)
		{
			canceled = true;
			Hide();
		}
		#endregion;
	}
}
